<?php
/*
Plugin Name: 123 Dentist Promotions Plugin
Plugin URI: http://aheadoftheweb.com/
Description: This plugin fetches and stores promotional information on the clinic site.
Author: Ahead of the Web
Author URI: http://aheadoftheweb.com
Version: 0.05
*/

/**
 * Setup native automatic theme update functionality
 */
require 'update-checker/plugin-update-checker.php';
$myUpdateChecker = Puc_v4_Factory::buildUpdateChecker(
	'https://updates.aheadoftheweb.com/?action=get_metadata&slug=aow_promo',
	__FILE__,
	'aow_promo'
);


// Uninstall script
register_uninstall_hook(__FILE__,'aow_promo_child_deactivate');
// On uninstall delete all database entires made by the plugin
function aow_promo_child_deactivate(){
	delete_option( 'widget_sc123_child_promo' );
	delete_option( 'sc123_promo_hastitle' );
	delete_option( 'sc123_promo_title' );
	delete_option( 'sc123_promo_content' );
	delete_option( 'sc123_promo_displaystate' );
}
add_action( 'admin_menu', 'aow_promo_menu_items' );
function aow_promo_menu_items(){
	
	// Create main menu instance in child dashboard
	add_menu_page( 'Promotions from 123 Dentist', 'Promotions', 'manage_options', 'aow-promo', 'aow_promo_home' );
	add_submenu_page('aow-promo' , 'Network Promotions' , 'Network Promotions' , 'manage_options' , 'aow-promo-home' , 'aow_promo_content');
	
	/* [TEMPLATE!] Create sub-menu instance [submenu]
	add_submenu_page('sharecontent-child' , 'Child Site Controls' , 'Child Site Controls' , 'manage_options' , 'sharecontent-template' , 'sharecontent_template');
	*/
	
}

// Include file for Home View 
function aow_promo_home(){
	require_once('includes/view-home.php');
}

// Include file for Promo Content Management
function aow_promo_content(){
	require_once('includes/view-promo-content.php');
}


// Include file for Child Site Management
/*function sharecontent_template(){
	require_once('includes/file-name.php');
}
*/

// Load custom CSS for styling widgets
add_action( 'wp_enqueue_scripts', 'aow_promo_register_plugin_styles' );

function aow_promo_register_plugin_styles() {
    wp_register_style( 'aow-promo', plugins_url( 'aow_promo/css/contentshare.css' ) );
	wp_enqueue_style( 'aow-promo' );
	/*
	$siteurl = site_url();
    $url = $siteurl . '/wp-content/plugins/' . basename(dirname(__FILE__)) . '/css/contentshare.css';
    echo "<link rel='stylesheet' type='text/css' href='$url' />\n";
	*/
}

class Aow_Promo extends WP_Widget {
          /**
			 * Register widget with WordPress
			 */
			public function __construct() {
				parent::__construct(
					'aow_promo', // Base ID
					__('AoW Promotions', 'text_domain'), // Widget Name
					array( 'description' => __( 'Promotions from 123 Dentist Network', 'text_domain' ), ) // Widget Description
				);
			}
			
			/**
			 * Front-end display of promo widget
			 */
			public function widget( $args , $instance ) {
					//Our variables from the widget settings.
					$title = apply_filters( 'widget_title' , $instance['title'] );
					
					$name = $instance['content'];
					$show_info = isset( $instance['show_info'] ) ? $instance['show_info'] : false;
					$sharecontenthaswidgettitle=get_option("sc123_promo_hastitle");
					$sharecontentwidgettitle=get_option("sc123_promo_title");
					$sharecontentcontent=get_option("sc123_promo_content");
					$sharecontentdisplaystate=get_option("sc123_promo_displaystate");
					
					if($instance['show_info'] == 'on'){
							echo $args[ 'before_widget' ];
							// Display the widget title 
								if ( $title )
								echo $args[ 'before_title' ] . $title . $args[ 'after_title' ];
							//Display the name 
							
							if ($instance['content']){
								echo $instance['content'];
							}else{
								echo 'There are no current promotions.';
							}
							echo $args[ 'after_widget' ];
					}else{
						if($sharecontentdisplaystate=="no"){
							return '';
						}
							echo $args[ 'before_widget' ];
							// Display the widget title 
							if($sharecontenthaswidgettitle=="no"){
								if ( $title )
								echo $args[ 'before_title' ] . $title . $args[ 'after_title' ];
							}else{
								echo $args[ 'before_title' ] . $sharecontentwidgettitle . $args[ 'after_title' ];
							}
							//Display the name 
							
							if ($sharecontentcontent)
								echo $sharecontentcontent;
							echo $args[ 'after_widget' ];
					}
          }
          /**
			 * Sanitize widget form values as they are saved.
			 */
			public function update( $new_instance, $old_instance ) {
				//Strip tags from title and name to remove HTML 
				$instance['title'] = strip_tags( $new_instance['title'] );
				$instance['content'] = ( $new_instance['content'] );
				$instance['show_info'] = $new_instance['show_info'];
				return $instance;
			} 
          /**
			 * Back-end widget form
			 */
			 public function form( $instance ) {
			 	// Get title if there is one, if not set default title
				$defaults = array( 'title' => __('Ahead of the Web Promotions', 'example'), 'show_info' => true );
			$instance = wp_parse_args( (array) $instance, $defaults ); ?>
			<p>
				<label for="<?php echo $this->get_field_id( 'title' ); ?>">Title:</label>
				<input id="<?php echo $this->get_field_id( 'title' ); ?>" name="<?php echo $this->get_field_name( 'title' ); ?>" value="<?php echo strlen($instance['title'])==0?"Ahead of the Web Promotions":$instance['title']; ?>" style="width:95%;" />
			</p>
           
           <p>
				<label for="<?php echo $this->get_field_id( 'name' ); ?>">HTML Content</label>
				<textarea id="<?php echo $this->get_field_id( 'content' ); ?>" name="<?php echo $this->get_field_name( 'content' ); ?>" style="width:100%;"><?php echo $instance['content']; ?></textarea>
			</p>
			<p>
				<input class="checkbox" type="checkbox" value="on" <?php checked("on",$instance['show_info'], true ); ?> id="<?php echo $this->get_field_id( 'show_info' ); ?>" name="<?php echo $this->get_field_name( 'show_info' ); ?>" /> 
				<label for="<?php echo $this->get_field_id( 'show_info' ); ?>"><?php _e('Override Parent Content?', 'example'); ?></label>
			</p>
		<?php
		}
} 

// class Child_Promo

// Call Register Widget Function
add_action( 'widgets_init', 'aow_promo_load_widgets' );

// Register & Load Widgets
function aow_promo_load_widgets() {
	register_widget( 'Aow_Promo' );
}

// Respond to 'ping' and get content from parent
if(isset($_GET['task']) && $_GET['task']=="pushcontent"){
	if(isset($_GET['id'])){
		aowpromotionscontentchildfetchfeed($_GET['id']);
	}
	die;
}

// Get content from parent and save to database
function aowpromotionscontentchildfetchfeed($id){
	// Build admin url
	$adminurl=get_option("sc123_adminfeedurl")."&id=".$id;
	// Download contents from parent via function [file_get_contents]
	$cont=file_get_contents($adminurl);
	// Create PHP array out of JSON 
	$cont=json_decode($cont);
	// If display state is set to no, set display state to no and don't update database 
	if($cont->sc_promo_displaystate=="no"){
		update_option("sc123_promo_displaystate",'no');
	}else{		
		update_option("sc123_promo_hastitle",		$cont->sc_promo_hastitle);
		update_option("sc123_promo_title",			$cont->sc_promo_title);
		update_option("sc123_promo_content",		$cont->sc_promo_content);
		update_option("sc123_promo_displaystate",	'yes');
	}
}

// Plugin Installation Registration
register_activation_hook( __FILE__, 'aowpromo_activate' );

// Installation Function
function aowpromo_activate(){
	// Set admin URL
	$sharecontentadminurl='https://dentistbc.com/'; //example: http://olympicvillagedental.com/
	
	// Trim admin URL
	$sharecontentadminurl=trim($sharecontentadminurl,'/');
	// Enter admin URL into database
	update_option( 'sc123_adminfeedurl', $sharecontentadminurl.'/?task=sharecontent_fetchfeed' );
}

// Register shortcode versions of widgets
add_shortcode('sharecontent','aowpromo_func');

// Shortcode Function
// Shortcode for promotional content
function aowpromo_func($atts){
	ob_start();
	$sharecontenthaswidgettitle=get_option("sc123_promo_hastitle");
	$sharecontentwidgettitle=get_option("sc123_promo_title");
	$sharecontentcontent=get_option("sc123_promo_content");
	$defaulttitle='123 Dentist Promotions'; 
	echo '<div class="promo_shortcode">';
		if($sharecontenthaswidgettitle=="no"){
			if(isset($atts['title'])){
			?><h2><?php	echo $atts['title']; ?></h2><?php
			}else{
			?><h2><?php echo $defaulttitle; ?></h2><?php
			}
		}else{
			?><h2><?php echo $sharecontentwidgettitle; ?></h2><?php
		}
		echo $sharecontentcontent;
		echo '</div>';
	return ob_get_clean();
}

?>