<?php
/**
 * Business Information
 *
 * Main Business Information Content
 */

//Format Ratings Properly
$rating       = 0;
$rating_count = 0;
$rating_total = 0;
if ( ! empty( $businesses[ $x ]->ratings->data ) ) {
	foreach ( $businesses[ $x ]->ratings->data as $line_rating ) {
		$rating += $line_rating->rating;
		$rating_count += 1;
	}
	$rating_total = apply_filters('fb_widget_pro_star_rating_total', round( $rating / $rating_count ), $rating, $rating_count);
}
/**
 * Find the biggest business profile image.
 */
foreach ( $businesses[ $x ]->albums->data as $album ) {
	if ( $album->name == 'Profile Pictures' ) {
		$profile_image = $album->picture->data->url;
	}
}

// Ensure we have a profile image, if not use fallback.
if ( empty( $profile_image ) ) {
	if ( ! empty( $businesses[ $x ]->picture->data->url ) ) {
		$profile_image = $businesses[ $x ]->picture->data->url;
	} else {
		$profile_image = FB_WIDGET_PRO_URL . '/assets/images/blank-biz.png';
	}
}
?>

<div class="facebook-business-info fb-widget-clearfix <?php echo $this->profile_image_size( $instance['profile_img_size'], '' ); ?><?php echo $instance['display_reviews'] !== '1' ? ' fbw-hide-reviews' : ''; ?>">
    <div class="biz-img-wrap">
        <img class="picture" src="<?php echo $profile_image; ?>"
             alt="<?php echo esc_attr( $businesses[ $x ]->name ); ?>" <?php echo $this->profile_image_size( $instance['profile_img_size'], 'size' ); ?>/>
    </div>

    <div class="fb-widget-business-info fb-widget-clearfix">
        <div class="facebook-business-name-wrap">
			<?php
			/**
			 * Display business website with link.
			 */
			if ( ! empty( $businesses[ $x ]->website ) ) : ?>
                <a class="facebook-business-name-link" <?php echo $instance['target_blank'] . $instance['no_follow']; ?>
                   href="<?php echo esc_attr( $businesses[ $x ]->link ); ?>"
                   title="<?php echo esc_attr( $businesses[ $x ]->name ); ?> Facebook page"><?php echo $businesses[ $x ]->name; ?></a>
			<?php else :
				/**
				 * This business does not have a website listed, display the name name instead.
				 */
				echo $businesses[ $x ]->name;
			endif ?>
        </div>

        <div class="facebook-aggregate-rating">
			<?php
			/**
			 * The star rating.
			 */
			if ( 0 !== $rating_total ) :
				$star_rating = sprintf( _n( '%1$s star %2$s', '%1$s stars %2$s', intval( $rating_total ), 'facebook-reviews-pro' ), $rating_total, '&#8212;' );
				?>
                <span class="facebook-review-rating base-rate-<?php echo $rating_total; ?>">
                    <?php echo apply_filters( 'fb_business_review_star_rating_text', $star_rating ); ?>
                    <span class="facebook-review-stars">
						<?php for ( $i = 1; $i <= $rating_total; $i ++ ) {
							echo '&#9733;';
						}
						?>
					</span>
				</span>
			<?php else : ?>
                <a href="<?php echo $businesses[ $x ]->link; ?>"
					<?php echo $instance['target_blank'] . $instance['no_follow']; ?>
                   class="no-reviews-link facebook-review-rating"><?php echo apply_filters( 'facebook_no_reviews_message', esc_html__( 'Be the first to review', 'facebook-reviews-pro' ) . ' &raquo;' ); ?></a>
			<?php endif; ?>
        </div>

        <div class="facebook-logo-link-wrap">
            <a class="facebook-logo-link"
               href="<?php echo esc_attr( $businesses[ $x ]->link ); ?>"
                <?php echo $instance['target_blank'] . $instance['no_follow']; ?>><img
                        src="<?php echo FB_WIDGET_PRO_URL . '/assets/images/facebook.png'; ?>"
                        alt="<?php echo $businesses[ $x ]->name; ?> <?php esc_html_e( 'on Facebook', 'facebook-reviews-pro' ); ?>"/></a>
        </div>

    </div>
	<?php if ( $instance['display_address'] == 1 || $instance['display_phone'] == 1 ) { ?>
        <div class="facebook-address-wrap">
			<?php
			/**
			 * Display Business Address & Phone Number
			 */

			//Address
			if ( $instance['display_address'] == 1 && ! empty( $businesses[ $x ]->location ) ) {
				echo $this->display_address( $businesses[ $x ]->location );
			}


			//Phone
			if ( $instance['display_phone'] == 1 && ! empty( $businesses[ $x ]->phone ) && false === strpos( $businesses[ $x ]->phone, 'not-applicable' ) ) { ?>
                <div class="fwp-phone"><?php echo $businesses[ $x ]->phone; ?></div>
			<?php } //endif phone	?>

        </div>
	<?php } ?>

</div><!--/.facebook-business-info -->