<?php
/**
 * Display Google Map with Facebook listings
 */

if ( empty( $businesses[0]->location ) ) {
	return;
}

$jsonArray = '{"results": [' . $jsonArray . ']}';
if ( '1' === $instance['display_google_map'] ) {
	$settings = get_option( 'fb_widget_settings' );
	if ( isset( $settings['fb_widget_maps_api'] ) && ! empty( $settings['fb_widget_maps_api'] ) ) {
		// Display Google Map.
		$attr_class  = ! empty( $instance['google_map_position'] ) ? ' facebook-map-' . $instance['google_map_position'] : '';
		$attr_scroll = '1' === $instance['disable_map_scroll'] ? 'false' : 'true';
		?>
        <div class="facebook-map-container<?php echo esc_attr( $attr_class ) ?>"
             data-map-scroll="<?php echo esc_attr( $attr_scroll ) ?>">
            <div class="facebook-map"></div>
        </div>
		<?php
	} elseif ( current_user_can( 'update_plugins' ) ) {
		// Display error only to logged-in users who can update plugins.
		?>
        <div class="facebook-map-error-container">
            <div class="facebook-map-error">
                <h2><?php esc_html_e( 'Oops!', 'facebook-reviews-pro' ) ?></h2>
                <p>
					<?php
					$doc_url = 'https://wordimpress.com/documentation/facebook-reviews-pro/';
					printf( wp_kses( __( 'You must set a Google Maps API key in order to display a map.<br><a href="%s">Learn how to create a Google Maps API key.</a>', 'facebook-reviews-pro' ), array( 'a'  => array( 'href' => array() ),
					                                                                                                                                                                                      'br' => array()
					) ), esc_url( $doc_url ) );
					?>
                </p>
            </div>
        </div>
	<?php } ?>
<?php }
