<?php
/**
 * Plugin Name: Yellow Pages Reviews Pro
 * Plugin URI: https://wordimpress.com/plugins/yellow-pages-reviews-pro/
 * Description: Display an Yellow Pages Reviews for your business using an easy to use and intuitive shortcode and widget.
 * Version: 1.0.3
 * Author: WordImpress
 * Author URI: https://wordimpress.com
 * Text Domain: ypr
 */

if ( ! defined( 'YPR_PLUGIN_NAME' ) ) {
	define( 'YPR_PLUGIN_NAME', 'yellow-pages-reviews' );
}
if ( ! defined( 'YPR_PLUGIN_NAME_PLUGIN' ) ) {
	define( 'YPR_PLUGIN_NAME_PLUGIN', plugin_basename( __FILE__ ) );
}
if ( ! defined( 'YPR_PLUGIN_PATH' ) ) {
	define( 'YPR_PLUGIN_PATH', untrailingslashit( plugin_dir_path( __FILE__ ) ) );
}
if ( ! defined( 'YPR_PLUGIN_URL' ) ) {
	define( 'YPR_PLUGIN_URL', plugins_url( basename( plugin_dir_path( __FILE__ ) ), basename( __FILE__ ) ) );
}
if ( ! defined( 'YPR_DEBUG' ) ) {
	define( 'YPR_DEBUG', false );
}


/**
 * Register Yellow Pages widget.
 *
 * @return YPR_Plugin_Framework
 */
function init_yellow_pages_reviews_widget() {

	// Include Core Framework class
	require_once YPR_PLUGIN_PATH . '/classes/core.php';
	require_once YPR_PLUGIN_PATH . '/admin/settings.php';
	require_once YPR_PLUGIN_PATH . '/inc/licence/licence.php';

	// Include Licensing.
	if ( ! class_exists( 'EDD_SL_Plugin_Updater' ) ) {
		// load our custom updater.
		include_once( YPR_PLUGIN_PATH . '/inc/licence/classes/EDD_SL_Plugin_Updater.php' );
	}

	if ( is_admin() ) {
		include YPR_PLUGIN_PATH . '/admin/admin.php';
	}

	//	global $yellow_pages_reviews;
	// Create plugin instance
	$yellow_pages_reviews = new YPR_Plugin_Framework( __FILE__ );

	// Create options page.
	$yellow_pages_reviews->add_options_page( array(), ypr_get_settings() );

	//Include the widget
	if ( ! class_exists( 'Yellow_Pages_Reviews' ) ) {
		require 'classes/widget.php';
		require 'classes/shortcode.php';
		$ypr_shortcode = new Yellow_Pages_Reviews_Shortcode();
	}

	return $yellow_pages_reviews;

}

add_action( 'widgets_init', 'init_yellow_pages_reviews_widget' );
add_action( 'widgets_init', create_function( '', 'register_widget( "Yellow_Pages_Reviews" );' ) );


/**
 * Custom CSS for Options Page.
 *
 * @param $hook
 */
function ypr_options_scripts( $hook ) {

	$suffix = defined( 'YPR_DEBUG' ) && YPR_DEBUG ? '' : '.min';

	if ( $hook === 'settings_page_yellowpagesreviews' ) {
		wp_register_style( 'ypr_custom_options_styles', plugin_dir_url( __FILE__ ) . 'assets/css/options' . $suffix . '.css' );
		wp_enqueue_style( 'ypr_custom_options_styles' );

	}
}

add_action( 'admin_enqueue_scripts', 'ypr_options_scripts' );
